/*  -*- c++ -*-  (for Emacs)
 *
 *  elementevents.h
 *  Digest
 * 
 *  Imported into Digest by Aidan Lane on Thu Jun 9 2005.
 *  Modifications Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  Nodal file:
 *
 *    Imported into Nodal by Aidan Lane on Thu Feb 24 2005.
 *    Modifications Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *    Original file:
 *
 *      projectevent.h
 *      EverGreen
 *
 *      Created by Aidan Lane on Sun Aug 01 2004.
 *      Copyright (c) 2004 Aidan Lane. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

 
#ifndef ELEMENTEVENTS_H
#define ELEMENTEVENTS_H


#include "modelevents.h"
#include "elementdoccontainers.h"


/*!
 * This is a base class for other events, which can only be inherited from.
 *
 * Note: as we are sending the event TO an element, we do not need to include the
 *       element's address in the event object.
 */
class MEElementEvent : public MEvent {
public:
  enum Type {
    AttributeAddPtr     = MEvent::User,
    AttributeRemovePtr,
    User                = MEvent::User + 1000
  };

public:
  MEElementEvent( Type type )
    : MEvent((MEvent::Type)type) {}
};


class MEAttributeEvent : public MEElementEvent, public AbstractElementAttributeContainer {
public:
  MEAttributeEvent( Type type, AbstractElementAttribute* attribute )
    : MEElementEvent(type),
      AbstractElementAttributeContainer(attribute) {}
};


/*! \brief Convenience class. */
class MEAttributeAddPtrEvent : public MEAttributeEvent {
public:
  MEAttributeAddPtrEvent( AbstractElementAttribute* attribute )
    : MEAttributeEvent(AttributeAddPtr, attribute) {}
};

/*! \brief Convenience class. */
class MEAttributeRemovePtrEvent : public MEAttributeEvent {
public:
  MEAttributeRemovePtrEvent( AbstractElementAttribute* attribute )
    : MEAttributeEvent(AttributeRemovePtr, attribute) {}
};


#endif // ! ELEMENTEVENTS_H
