/*  -*- c++ -*-  (for Emacs)
 *
 *  modelevents.h
 *  Digest
 * 
 *  Created by Aidan Lane on Mon Aug 29 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef MODELEVENTS_H
#define MODELEVENTS_H


#include "mvcevent.h"
#include "mvccontainers.h"


class AbstractController;


/*!
 * Base class for Model events in the Model-View-Controller event
 * system.
 *
 * Using and extending MEvent offers thread-safe event queuing (using postEvent)
 * and minial coupling.
 */
class MEvent : public MvcEvent {
public:
  enum Type {
    ChangeController  = MvcEvent::User,
    User              = MvcEvent::User + 1000
  };

  MEvent( Type type )
    : MvcEvent((MvcEvent::Type)type) {}

  /*! Returns the desination type for this event, which is MvcEvent::Model. */
  inline static DestType classDestType() { return Model; }
  /*! Returns classDestType(). */
  virtual DestType destType() const { return classDestType(); }
};


class MChangeControllerEvent : public MEvent, public AbstractControllerContainer {
public:
  MChangeControllerEvent( AbstractController* controller )
    : MEvent(ChangeController),
      AbstractControllerContainer(controller) {}
};


#endif // ! MODELEVENTS_H
