/*  -*- c++ -*-  (for Emacs)
 *
 *  mvcbase.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Sep 1 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef MVCBASE_H
#define MVCBASE_H


#include "mvccore.h"

class QObject;


class MvcBase {

public:
  MvcBase( QObject* objectPtr )
    : m_objectPtr(objectPtr) {}
  virtual ~MvcBase() {}


  QObject* objectPtr() { return m_objectPtr; }

  /*!
   * Returns MvcCore::id().
   *
   * This should be re-implemented this in the base MVC class of other modules.
   */
  inline static MvcModuleId_t classModuleId() { return MvcCore::id(); }

  /*!
   * Returns classModuleId().
   *
   * This should be re-implemented this in the base MVC class of other modules.
   */
  virtual MvcModuleId_t moduleId() const { return classModuleId(); }


private:
  QObject* m_objectPtr;
};


#endif  // ! MVCBASE_H
