/*  -*- c++ -*-  (for Emacs)
 *
 *  mvccore.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Aug 25 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "mvccore.h"

#include <QSet>


/*!
 * Generates a unique ID, starting from 1.
 *
 * Returns 0 on failure (will virtually never occur in practice).
 */
MvcModuleId_t MvcCore::generateNewId()
{
  static QSet<MvcModuleId_t> usedIds;

  for ( MvcModuleId_t i=1; i < (MvcModuleId_t)-1; ++i )
    if ( ! usedIds.contains(i) ) {
      usedIds.insert( i );
      return i;
    }

  Q_ASSERT( !"All possible MVC module IDs have been exhausted - WOW!" );

  return 0;
}
