/*  -*- c++ -*-  (for Emacs)
 *
 *  mvccore.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Aug 25 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef MVCCORE_H
#define MVCCORE_H


#include <stdint.h>


typedef uint32_t MvcModuleId_t;


/*!
 * \brief The MvcCore class is a base for all Model-View-Controller modules.
 *
 * The id() is very important when combining multiple MVC modules together,
 * where event IDs may overlap. By checking the (unique) id() first, you can
 * ensure that the events are sent and handled correctly.
 */
class MvcCore {

public:
  enum ElementType {
    UserElement = 1000
  };

  enum ElementAttributeType {
    UserElementAttribute = 1000
  };

  /*!
   * Returns the module's id().
   *
   * This method must be re-implemented in \em every sub-class as:
   * \code
   * inline static MvcModuleId_t id() {
   *   static s_id = generateNewId();
   *   return s_id;
   * }
   * \endcode
   *
   * The id() is very important when combining multiple MVC modules together,
   * where event IDs may overlap. By checking the (unique) id() first, you can
   * ensure that the events are sent and handled correctly.
   */
  inline static MvcModuleId_t id() {
    static MvcModuleId_t s_id = generateNewId();
    return s_id;
  }


protected:
  static MvcModuleId_t generateNewId();
};


#endif  // ! MVCCORE_H
