/*  -*- c++ -*-  (for Emacs)
 *
 *  mvcevent.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Aug 25 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef MVCEVENT_H
#define MVCEVENT_H


#include <QEvent>

#include "mvccore.h"


/*!
 * Base class for the Model-View-Controller events: MEvent, VEvent, and CEvent.
 */
class MvcEvent : public QEvent {

public:
  /*! Destination type. */
  enum DestType {
    Unknown,
    Model,
    View,
    Controller
  };

  MvcEvent( Type type )
    : QEvent(type) {}

  /*!
   * Returns MvcCore::id().
   *
   * This should be re-implemented this in the base event class of other modules.
   */
  inline static MvcModuleId_t classModuleId() { return MvcCore::id(); }
  /*!
   * Returns classModuleId().
   *
   * This should be re-implemented this in the base event class of other modules.
   */
  virtual MvcModuleId_t moduleId() const { return classModuleId(); }

  /*! Returns the destination type (DestType) for the event class. */
  inline static DestType classDestType() { return Unknown; }
  /*! Returns the destination type (DestType) for the event, classDestType(). */
  virtual DestType destType() const { return classDestType(); }
};


#endif  // ! MVCEVENT_H
