/*
 *  abstractattributedocview.cpp
 * 
 *  Created by Aidan Lane on Tue Dec 20 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "abstractattributedocview.h"

#include "attributedoc.h"
#include "attributedoccontroller.h"


AbstractAttributeDocView::AbstractAttributeDocView( QObject* objectPtr )
  : AbstractDocView(objectPtr)
{}


/*!
 * Convenience method.
 *
 * Returns a cached guarded pointer that has been dynamically cast to
 * AttributeDocController* from AbstractController*.
 *
 * See also AbstractView::controller().
 */
AttributeDocController* AbstractAttributeDocView::attributeDocController() const {
  return c_attributeDocController;
}


/*!
 * Convenience method.
 *
 * Returns a cached guarded pointer that has been dynamically cast to
 * AttributeDoc* from AbstractModel*.
 *
 * See also AbstractView::model().
 */
AttributeDoc* AbstractAttributeDocView::attributeDoc() const {
  return c_attributeDoc;
}


void AbstractAttributeDocView::dispatchEvent( VEvent* event )
{
  Q_ASSERT( event != 0 );

  AbstractDocView::dispatchEvent( event );

  if ( event->moduleId() != MvcCore::id() ) return; // prevent event type conflicts

  switch ( event->type() )
    {
    case VAttributeDocEvent::AttributesValuesSet:
      attributesValuesSetEvent( static_cast<VAttributesValuesSetEvent*>(event) ); break;
    case VAttributeDocEvent::AttributesRemoved:
      attributesRemovedEvent( static_cast<VAttributesRemovedEvent*>(event) ); break;
    default:
      break;
    }
}


/*!
 * Re-implemented, as to also have the pointer returned by attributeDocController()
 * updated.
 *
 * Asserts that the \em event is non-null.
 */
void AbstractAttributeDocView::changeControllerEvent( VChangeControllerEvent* event )
{
  Q_ASSERT( event != 0 );
  AbstractDocView::changeControllerEvent( event );
  c_attributeDocController
    = ( (event->controller()==0)
	? 0
	: qobject_cast<AttributeDocController*>(event->controller()->objectPtr()) );
}


/*!
 * Re-implemented, as to also have the pointer returned by attributeDoc() updated.
 *
 * Asserts that the \em event is non-null.
 */
void AbstractAttributeDocView::modelChangedEvent( VModelChangedEvent* event )
{
  Q_ASSERT( event != 0 );
  AbstractDocView::modelChangedEvent( event );
  c_attributeDoc
    = ( (event->model()==0)
	? 0
	: qobject_cast<AttributeDoc*>(event->model()->objectPtr()) );
}
