/*  -*- c++ -*-  (for Emacs)
 *
 *  abstractattributedocview.h
 * 
 *  Created by Aidan Lane on Tue Dec 20 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef ABSTRACTATTRIBUTEDOCVIEW_H
#define ABSTRACTATTRIBUTEDOCVIEW_H


#include "abstractdocview.h"

#include "attributedocviewevents.h"

class AttributeDoc;
class AttributeDocController;


class AbstractAttributeDocView : public AbstractDocView {

public:
  AbstractAttributeDocView( QObject* objectPtr );

  AttributeDocController*  attributeDocController() const;
  AttributeDoc*            attributeDoc() const;


protected:
  virtual void dispatchEvent( VEvent* );

  virtual void changeControllerEvent( VChangeControllerEvent* );
  virtual void modelChangedEvent( VModelChangedEvent* );

  // The following implementations do nothing, derivative classes are left to
  // add functionality.
  virtual void attributesValuesSetEvent( VAttributesValuesSetEvent* ) {}
  virtual void attributesRemovedEvent( VAttributesRemovedEvent* ) {}


private:
  // Temporary caches:
  QPointer<AttributeDocController>  c_attributeDocController;
  QPointer<AttributeDoc>            c_attributeDoc;
};


#endif //  ! ABSTRACTATTRIBUTEDOCVIEW_H
