/*
 *  abstractdocview.cpp
 *  Digest
 * 
 *  Imported into Digest by Aidan Lane on Thu Jun 9 2005.
 *  Modifications Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  Nodal file:
 *
 *    projectobserver.h
 *    Nodal
 *
 *    Imported into Nodal by Aidan Lane on Thu Feb 24 2005.
 *    Modifications Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *    Original file:
 *
 *      projectview.h
 *      EverGreen
 *
 *      Created by Aidan Lane on Wed Jul 14 2004.
 *      Copyright (c) 2004 Aidan Lane. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "abstractdocview.h"

#include <QCoreApplication>
#include <QString>

#include "doc.h"
#include "doccontroller.h"


AbstractDocView::AbstractDocView( QObject* objectPtr )
  : AbstractView(objectPtr)
{}


/*!
 * Convenience method.
 *
 * Returns a cached guarded pointer that has been dynamically cast to
 * DocController* from AbstractController*.
 *
 * See also AbstractView::controller().
 */
DocController* AbstractDocView::docController() const {
  return c_docController;
}


/*!
 * Convenience method.
 *
 * Returns a cached guarded pointer that has been dynamically cast to
 * Doc* from AbstractModel*.
 *
 * See also AbstractView::model().
 */
Doc* AbstractDocView::doc() const {
  return c_doc;
}


/*
 * Dispatch events to the appropriate event handling methods.
 *
 * Note: The reason that this is not called "customEvent" is because this
 *       abstract class does not sub-class QObject, that is left up to a
 *       sub-class of this class to do. Therefore, in the class that does
 *       sub-class QObject, it should re-implement the "customEvent" method and
 *       call this.
 *
 * Warning: This method is assumes that the events have their correct type set,
 *          as it uses static casts.
 *
 * Note: This asserts that the event pointer is non-null.
 */
void AbstractDocView::dispatchEvent( VEvent* event )
{
  Q_ASSERT( event != 0 );

  AbstractView::dispatchEvent( event );

  if ( event->moduleId() != MvcCore::id() ) return; // prevent event type conflicts

  switch ( event->type() )
    {
    case VDocEvent::Renamed:
      renamedEvent( static_cast<VRenamedEvent*>(event) );
      break;
    case VDocEvent::FilenameChanged:
      filenameChangedEvent( static_cast<VFilenameChangedEvent*>(event) );
      break;
    case VDocEvent::ModifiedStateChanged:
      modifiedStateChangedEvent( static_cast<VModifiedStateChangedEvent*>(event) );
      break;
    default:
      break;
    }
}


/*!
 * Re-implemented, as to also have the pointer returned by docController()
 * updated.
 *
 * Asserts that the \em event is non-null.
 */
void AbstractDocView::changeControllerEvent( VChangeControllerEvent* event )
{
  Q_ASSERT( event != 0 );
  AbstractView::changeControllerEvent( event );
  c_docController
    = ( (event->controller()==0)
	? 0
	: qobject_cast<DocController*>(event->controller()->objectPtr()) );
}


/*!
 * Re-implemented, as to also have the pointer returned by doc() updated.
 *
 * Asserts that the \em event is non-null.
 */
void AbstractDocView::modelChangedEvent( VModelChangedEvent* event )
{
  Q_ASSERT( event != 0 );
  AbstractView::modelChangedEvent( event );
  c_doc = ( (event->model()==0)
	    ? 0
	    : qobject_cast<Doc*>(event->model()->objectPtr()) );
}
