/*  -*- c++ -*-  (for Emacs)
 *
 *  abstractdocview.h
 *  Digest
 * 
 *  Imported into Digest by Aidan Lane on Thu Jun 9 2005.
 *  Modifications Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  Nodal file:
 *
 *    projectobserver.h
 *    Nodal
 *
 *    Imported into Nodal by Aidan Lane on Thu Feb 24 2005.
 *    Modifications Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *    Original file:
 *
 *      projectview.h
 *      EverGreen
 *
 *      Created by Aidan Lane on Wed Jul 14 2004.
 *      Copyright (c) 2004 Aidan Lane. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */


#ifndef ABSTRACTDOCVIEW_H
#define ABSTRACTDOCVIEW_H


#include "abstractview.h"

#include <QPointer>

#include "docviewevents.h"

class Doc;
class DocController;


/*!
 * The AbstractDocView class adds an event handler to AbstractView.
 */
class AbstractDocView : public AbstractView {

public:
  AbstractDocView( QObject* objectPtr );

  DocController* docController() const;
  Doc* doc() const;


protected:
  virtual void dispatchEvent( VEvent* );

  virtual void changeControllerEvent( VChangeControllerEvent* );
  virtual void modelChangedEvent( VModelChangedEvent* );

  // The following implementations do nothing, derivative classes are left to
  // add functionality.
  virtual void renamedEvent( VRenamedEvent* ) {}
  virtual void filenameChangedEvent( VFilenameChangedEvent* ) {}
  virtual void modifiedStateChangedEvent( VModifiedStateChangedEvent* ) {}


private:
  // Temporary caches:
  QPointer<DocController> c_docController;
  QPointer<Doc>           c_doc;
};


#endif // ! ABSTRACTDOCVIEW_H
