/*
 *  abstractelementdocview.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 10 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "abstractelementdocview.h"

#include "elementdoc.h"
#include "elementdoccontroller.h"


AbstractElementDocView::AbstractElementDocView( QObject* objectPtr )
  : AbstractAttributeDocView(objectPtr)
{}


/*!
 * Convenience method.
 *
 * Returns a cached guarded pointer that has been dynamically cast to
 * ElementDocController* from AbstractController*.
 *
 * See also AbstractView::controller().
 */
ElementDocController* AbstractElementDocView::elementDocController() const {
  return c_elementDocController;
}


/*!
 * Convenience method.
 *
 * Returns a cached guarded pointer that has been dynamically cast to
 * ElementDoc* from AbstractModel*.
 *
 * See also AbstractView::model().
 */
ElementDoc* AbstractElementDocView::elementDoc() const {
  return c_elementDoc;
}


void AbstractElementDocView::dispatchEvent( VEvent* event )
{
  Q_ASSERT( event != 0 );

  AbstractAttributeDocView::dispatchEvent( event );

  if ( event->moduleId() != MvcCore::id() ) return; // prevent event type conflicts

  switch ( event->type() )
    {
    case VElementDocEvent::ElementAdded:
      elementAddedEvent( static_cast<VElementEvent*>(event) ); break;
    case VElementDocEvent::ElementRemoved:
      elementRemovedEvent( static_cast<VElementEvent*>(event) ); break;
    case VElementDocEvent::ElementAttributeAdded:
      elementAttributeAddedEvent( static_cast<VElementAttributeEvent*>(event) ); break;
    case VElementDocEvent::ElementAttributeRemoved:
      elementAttributeRemovedEvent( static_cast<VElementAttributeEvent*>(event) ); break;
    case VElementDocEvent::ElementAttributeDataChanged:
      elementAttributeDataChangedEvent( static_cast<VElementAttributeEvent*>(event) ); break;
    case VElementDocEvent::ElementSetOrderChanged:
      elementSetOrderChangedEvent( static_cast<VElementSetOrderChangedEvent*>(event) ); break;
    default:
      break;
    }
}


/*!
 * Re-implemented, as to also have the pointer returned by elementDocController()
 * updated.
 *
 * Asserts that the \em event is non-null.
 */
void AbstractElementDocView::changeControllerEvent( VChangeControllerEvent* event )
{
  Q_ASSERT( event != 0 );
  AbstractAttributeDocView::changeControllerEvent( event );
  c_elementDocController
    = ( (event->controller()==0)
	? 0
	: qobject_cast<ElementDocController*>(event->controller()->objectPtr()) );
}


/*!
 * Re-implemented, as to also have the pointer returned by elementDoc() updated.
 *
 * Asserts that the \em event is non-null.
 */
void AbstractElementDocView::modelChangedEvent( VModelChangedEvent* event )
{
  Q_ASSERT( event != 0 );
  AbstractAttributeDocView::modelChangedEvent( event );
  c_elementDoc
    = ( (event->model()==0)
	? 0
	: qobject_cast<ElementDoc*>(event->model()->objectPtr()) );
}
