/*  -*- c++ -*-  (for Emacs)
 *
 *  abstractelementdocview.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 10 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef ABSTRACTELEMENTDOCVIEW_H
#define ABSTRACTELEMENTDOCVIEW_H


#include "abstractattributedocview.h"

#include "elementdocviewevents.h"

class ElementDoc;
class ElementDocController;


class AbstractElementDocView : public AbstractAttributeDocView {

public:
  AbstractElementDocView( QObject* objectPtr );

  ElementDocController*  elementDocController() const;
  ElementDoc*            elementDoc() const;


protected:
  virtual void dispatchEvent( VEvent* );

  virtual void changeControllerEvent( VChangeControllerEvent* );
  virtual void modelChangedEvent( VModelChangedEvent* );

  // The following implementations do nothing, derivative classes are left to
  // add functionality.
  virtual void elementAddedEvent( VElementEvent* ) {}
  virtual void elementRemovedEvent( VElementEvent* ) {}
  virtual void elementAttributeAddedEvent( VElementAttributeEvent* ) {}
  virtual void elementAttributeRemovedEvent( VElementAttributeEvent* ) {}
  virtual void elementAttributeDataChangedEvent( VElementAttributeEvent* ) {}
  virtual void elementSetOrderChangedEvent( VElementSetOrderChangedEvent* ) {}


private:
  // Temporary caches:
  QPointer<ElementDocController>  c_elementDocController;
  QPointer<ElementDoc>            c_elementDoc;
};


#endif //  ! ABSTRACTELEMENTDOCVIEW_H
