/*  -*- c++ -*-  (for Emacs)
 *
 *  abstractview.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 9 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef ABSTRACTVIEW_H
#define ABSTRACTVIEW_H


#include "mvcbase.h"

#include <QPointer>

#include "viewevents.h"

class AbstractModel;
class AbstractController;
class CEvent;


#define DEFINE_CUSTOM_VIEWEVENT_HANDLER				\
  inline virtual void customEvent( QEvent* e ) {		\
    VEvent* ve = dynamic_cast<VEvent*>(e); /* slow :-( */	\
    if ( ve != 0 ) dispatchEvent(ve);				\
  }


/*!
 * \brief The AbstractView class provides an abstract base for all views in the
 *        Model-View-Controller system.
 */
class AbstractView : public MvcBase {

public:
  AbstractView( QObject* objectPtr );
  virtual ~AbstractView();

  AbstractController* controller() const;
  AbstractModel* model() const;


protected:
  virtual void dispatchEvent( VEvent* );

  virtual void changeControllerEvent( VChangeControllerEvent* );
  virtual void modelChangedEvent( VModelChangedEvent* );
  virtual void resetEvent( VEvent* );

  void postControllerEvent( CEvent* event );

  const QSet<AbstractView*> childViews();
  void addChildView( AbstractView* view );
  void removeChildView( AbstractView* view );
  void removeAllChildViews();


private:
  AbstractController* m_controller; // note: can't use QPointer
  QPointer<QObject>   m_controllerObject;
  AbstractModel*      m_model;      // note: can't use QPointer
  QPointer<QObject>   m_modelObject;
  QSet<AbstractView*> m_childViews;
};


#endif //  ! ABSTRACTVIEW_H
