/*  -*- c++ -*-  (for Emacs)
 *
 *  attributedocviewevents.h
 * 
 *  Created by Aidan Lane on Tue Dec 20 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef ATTRIBUTEDOCVIEWEVENTS_H
#define ATTRIBUTEDOCVIEWEVENTS_H


#include "docviewevents.h"


class VAttributeDocEvent : public VDocEvent {
public:
  enum Type {
    AttributesValuesSet  = VDocEvent::User,
    AttributesRemoved,
    User                 = VDocEvent::User + 1000
  };
protected:
  VAttributeDocEvent( Type type, MvcBase* sender )
    : VDocEvent((VDocEvent::Type)type, sender) {}
};


/*!
 * Values Set == Added or Changed/Modified
 * (i.e. was auto added if did not already exist).
 *
 * \b Note: This is not called "VAttributesSetEvent", because of the "set"
 *          container, which could cause confusion.
 */
class VAttributesValuesSetEvent : public VAttributeDocEvent,
				  public AttributesContainer {
public:
  VAttributesValuesSetEvent( const QHash<int, QVariant>& attributes,
			     MvcBase* sender = 0 )
    : VAttributeDocEvent(AttributesValuesSet, sender),
      AttributesContainer(attributes) {}

  VAttributesValuesSetEvent( int attributeType, const QVariant& attributeValue,
			     MvcBase* sender = 0 )
    : VAttributeDocEvent(AttributesValuesSet, sender),
      AttributesContainer(attributeType, attributeValue) {}
};


class VAttributesRemovedEvent : public VAttributeDocEvent,
				public AttributeTypesContainer {
public:
  VAttributesRemovedEvent( const QSet<int> attributeTypes, MvcBase* sender = 0 )
    : VAttributeDocEvent(AttributesRemoved, sender),
      AttributeTypesContainer(attributeTypes) {}

  VAttributesRemovedEvent( int attributeType, MvcBase* sender = 0 )
    : VAttributeDocEvent(AttributesRemoved, sender),
      AttributeTypesContainer(attributeType) {}
};


#endif //  ! ATTRIBUTEDOCVIEWEVENTS_H
