/*  -*- c++ -*-  (for Emacs)
 *
 *  docviewevents.h
 *  Digest
 * 
 *  Imported into Digest by Aidan Lane on Thu Jun 9 2005.
 *  Modifications Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  Nodal file:
 *
 *    projectviewevents.h
 *    Nodal
 *
 *    Imported into Nodal by Aidan Lane on Thu Feb 24 2005.
 *    Modifications Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *    Original file:
 *
 *      projectevent.h
 *      EverGreen
 *
 *      Created by Aidan Lane on Sun Aug 01 2004.
 *      Copyright (c) 2004 Aidan Lane. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
 
#ifndef DOCVIEWEVENTS_H
#define DOCVIEWEVENTS_H


#include "viewevents.h"
#include "genericcontainers.h"


class VDocEvent : public VEvent {
public:
  enum Type { 
    Renamed               = VEvent::User,
    FilenameChanged,
    ModifiedStateChanged,
    User                  = VEvent::User + 1000
  };
protected:
  VDocEvent( Type type, MvcBase* sender )
    : VEvent((VEvent::Type)type, sender) {}
};


class VRenamedEvent : public VDocEvent, public NameContainer {
public:
  VRenamedEvent( const QString& name, MvcBase* sender )
    : VDocEvent(Renamed, sender),
      NameContainer(name) {}
};

class VFilenameChangedEvent : public VDocEvent, public FilenameContainer {
public:
  VFilenameChangedEvent( const QString& filename, MvcBase* sender )
    : VDocEvent(FilenameChanged, sender),
      FilenameContainer(filename) {}
};

class VModifiedStateChangedEvent : public VDocEvent {
public:
  VModifiedStateChangedEvent( bool documentModified, MvcBase* sender )
    : VDocEvent(ModifiedStateChanged, sender),
      m_documentModified(documentModified) {}

  bool documentModified() const { return m_documentModified; }
private:
  const bool m_documentModified;
};


#endif //  ! DOCVIEWEVENTS_H
