/*  -*- c++ -*-  (for Emacs)
 *
 *  elementdocviewevents.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 10 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef ELEMENTDOCVIEWEVENTS_H
#define ELEMENTDOCVIEWEVENTS_H


#include "attributedocviewevents.h"
#include "elementdoccontainers.h"


class VElementDocEvent : public VAttributeDocEvent {
public:
  enum Type {
    ElementAdded                 = VAttributeDocEvent::User,
    ElementRemoved,
    ElementAttributeAdded,
    ElementAttributeRemoved,
    ElementAttributeDataChanged,
    ElementSetOrderChanged,
    User                         = VAttributeDocEvent::User + 1000
  };
protected:
  VElementDocEvent( Type type, MvcBase* sender )
    : VAttributeDocEvent((VAttributeDocEvent::Type)type, sender) {}
};


class VElementEvent : public VElementDocEvent,
		      public AbstractElementContainer {
public:
  VElementEvent( Type type, AbstractElement* element, MvcBase* sender )
    : VElementDocEvent(type, sender),
      AbstractElementContainer(element) {}
};


class VElementSetEvent : public VElementDocEvent,
			 public AbstractElementSetContainer {
public:
  VElementSetEvent( Type type,
		    const AbstractElementSet& elements, MvcBase* sender )
    : VElementDocEvent(type, sender),
      AbstractElementSetContainer(elements) {}
};


/*! \brief Convenience class. */
class VElementAddedEvent : public VElementEvent {
public:
  VElementAddedEvent( AbstractElement* element, MvcBase* sender )
    : VElementEvent(ElementAdded, element, sender) {}
};

/*! \brief Convenience class. */
class VElementRemovedEvent : public VElementEvent {
public:
  VElementRemovedEvent( AbstractElement* element, MvcBase* sender )
    : VElementEvent(ElementRemoved, element, sender) {}
};


class VElementAttributeEvent : public VElementEvent,
			       public AbstractElementAttributeContainer {
public:
  VElementAttributeEvent( Type type,
			  AbstractElement* element,
			  AbstractElementAttribute* attribute,
			  MvcBase* sender )
    : VElementEvent(type, element, sender),
      AbstractElementAttributeContainer(attribute) {}
};

/*! \brief Convenience class. */
class VElementAttributeAddedEvent : public VElementAttributeEvent {
public:
  VElementAttributeAddedEvent( AbstractElement* element,
			       AbstractElementAttribute* attribute,
			       MvcBase* sender )
    : VElementAttributeEvent(ElementAttributeAdded, element,
			     attribute, sender) {}
};

/*! \brief Convenience class. */
class VElementAttributeRemovedEvent : public VElementAttributeEvent {
public:
  VElementAttributeRemovedEvent( AbstractElement* element,
				 AbstractElementAttribute* attribute,
				 MvcBase* sender )
    : VElementAttributeEvent(ElementAttributeRemoved, element,
			     attribute, sender) {}
};

/*!
 * \brief Convenience class.
 *
 * To get the new data, simply call attribute()->toVariant().
 * There's no real point in passing the data on to all views, when few use it.
 */
class VElementAttributeDataChangedEvent : public VElementAttributeEvent {
public:
  VElementAttributeDataChangedEvent( AbstractElement* element,
				     AbstractElementAttribute* attribute,
				     MvcBase* sender )
    : VElementAttributeEvent(ElementAttributeDataChanged, element,
			     attribute, sender) {}
};


class VElementSetOrderChangedEvent : public VElementSetEvent,
				     public ElementOrderActionContainer {
public:
  VElementSetOrderChangedEvent( const AbstractElementSet& elements,
				Action action, MvcBase* sender )
    : VElementSetEvent(ElementSetOrderChanged, elements, sender),
      ElementOrderActionContainer(action) {}
};


#endif //  ! ELEMENTDOCVIEWEVENTS_H
