/*  -*- c++ -*-  (for Emacs)
 *
 *  diagramcontroller.h
 *  Digest
 * 
 *  Imported into Digest by Aidan Lane on Thu Jun 9 2005.
 *  Modifications Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  Nodal file:
 *
 *    projectcontroller.h
 *    Nodal
 *
 *    Imported into Nodal by Aidan Lane on Thu Feb 24 2005.
 *    Modifications Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *    Original file:
 *
 *      project.h
 *      EverGreen
 *
 *      Created by Aidan Lane on Wed Jul 14 2004.
 *      Copyright (c) 2004 Aidan Lane. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIAGRAMCONTROLLER_H
#define DIAGRAMCONTROLLER_H


#include "MvcCore/elementdoccontroller.h"

#include <QPointer>
#include <QReadWriteLock>

#include "diagramcontrollerevents.h"

class Diagram;


/*!
 * \brief The DiagramController class is responsible for controlling the
 *        communication between a Diagram and its views.
 *
 * Note that the diagram's pointer is stored internally as a "guarded pointer".
 * Hence, if the diagram is deleted, our reference to it will be automatically
 * set back to NULL.
 *
 * Warning! We always assert that the diagram is non-null. Hence, you can't
 * have an instance of a DiagramController without an AbstractModel. This is fine
 * for Digest and means that we don't need to constantly check if the diagram
 * is null in the release / deployment version (when assertions are stripped).
 */
class DiagramController : public ElementDocController {

  Q_OBJECT

public:
  DiagramController( QObject* parent = 0 );
  DiagramController( AbstractModel* diagram, QObject* parent = 0 );

  Diagram* diagram() const;

  /*!
   * Note: QSet has been used instead of QList, as the element order does not
   *       matter, it removes duplicates automatically and (obviously) provides
   *       set operations that are very useful when adding and removing items
   *       from selections (it's lookup speed is also very good).
   */
  const AbstractElementSet& elementSelection() const {
    return m_elementSelection;
  }

  /*! Returns MvcDiagram::id(). */
  inline static MvcModuleId_t classModuleId() { return MvcDiagram::id(); }
  /*! Returns classModuleId(). */
  virtual MvcModuleId_t moduleId() const { return classModuleId(); }


public slots:
  virtual void elementSelectionBringToFront();
  virtual void elementSelectionSendToBack();
  virtual void elementSelectionBringForward();
  virtual void elementSelectionSendBackward();


protected:
  virtual void dispatchEvent( CEvent* );

  virtual void changeModelEvent( CChangeModelEvent* );

  virtual void elementRemoveEvent( CElementRemoveEvent* );

  virtual void controlPointInsertEvent( CControlPointInsertEvent* );
  virtual void controlPointRemoveEvent( CControlPointRemoveEvent* );
  virtual void controlPointMoveEvent( CControlPointMoveEvent* );
  virtual void changeElementSelectionEvent( CChangeElementSelectionEvent* );
  virtual void removeAllSelectedElementsEvent( CDiagramEvent* );


private:
  // The following variable is only used for synchronising graphical representations.
  AbstractElementSet  m_elementSelection;
  mutable QReadWriteLock m_elementSelectionLock;

  // Temporary caches:
  QPointer<Diagram> c_diagram;
};


#endif // ! DIAGRAMCONTROLLER_H
