/*  -*- c++ -*-  (for Emacs)
 *
 *  diagramvariant.h
 *  Digest
 * 
 *  Created by Aidan Lane on Mon Dec 19 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIAGRAMVARIANT_H
#define DIAGRAMVARIANT_H


#include <QVariant>


/*!
 * \brief The DiagramVariant class extends QVariant to provide convenience methods
 *        for data types that are specific to the MvcDiagram library.
 *
 * Although it extends QVariant, it does not introduce any more data members,
 * thus it can be safely used interchangeably with QVariant.
 */
class DiagramVariant : public QVariant {

public:
  
  /*
   * The following constructors allow DiagramVariant to be used like QVariant.
   */
  DiagramVariant()                                        : QVariant() {}
  DiagramVariant( Type type )                             : QVariant(type) {}
  DiagramVariant( int typeOrUserType, const void* copy )  : QVariant(typeOrUserType, copy) {}
  DiagramVariant( const QVariant& p )                     : QVariant(p) {}
  DiagramVariant( QDataStream& s )                        : QVariant(s) {}
  DiagramVariant( int val )                               : QVariant(val) {}
  DiagramVariant( uint val )                              : QVariant(val) {}
  DiagramVariant( qlonglong val )                         : QVariant(val) {}
  DiagramVariant( qulonglong val )                        : QVariant(val) {}
  DiagramVariant( bool val )                              : QVariant(val) {}
  DiagramVariant( double val )                            : QVariant(val) {}
  DiagramVariant( const char* val )                       : QVariant(val) {}
  DiagramVariant( const QByteArray& val )                 : QVariant(val) {}
  DiagramVariant( const QBitArray& val )                  : QVariant(val) {}
  DiagramVariant( const QString& val )                    : QVariant(val) {}
  DiagramVariant( const QLatin1String& val )              : QVariant(val) {}
  DiagramVariant( const QStringList& val )                : QVariant(val) {}
  DiagramVariant( const QChar& c )                        : QVariant(val) {}
  DiagramVariant( const QDate& val )                      : QVariant(val) {}
  DiagramVariant( const QTime& val )                      : QVariant(val) {}
  DiagramVariant( const QDateTime& val )                  : QVariant(val) {}
  DiagramVariant( const QList<QVariant>& val )            : QVariant(val) {}
  DiagramVariant( const QMap<QString, QVariant>& val )    : QVariant(val) {}
  DiagramVariant( const QSize& val )                      : QVariant(val) {}
  DiagramVariant( const QSizeF& val )                     : QVariant(val) {}
  DiagramVariant( const QPoint& val )                     : QVariant(val) {}
  DiagramVariant( const QPointF& val )                    : QVariant(val) {}
  DiagramVariant( const QLine& val )                      : QVariant(val) {}
  DiagramVariant( const QLineF& val )                     : QVariant(val) {}
  DiagramVariant( const QRect& val )                      : QVariant(val) {}
  DiagramVariant( const QRectF& val )                     : QVariant(val) {}
  DiagramVariant( const QUrl& val )                       : QVariant(val) {}
  DiagramVariant( const QLocale& l )                      : QVariant(l) {}
  DiagramVariant( const QRegExp& regExp )                 : QVariant(regExp) {}
};


#endif  // ! DIAGRAMVARIANT_H
