/*
 *  diagramelementattributefactory.cpp
 *  Digest
 * 
 *  Imported into Digest by Aidan Lane on Thu Jun 9 2005.
 *  Modifications Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  Nodal file:
 *
 *    parcattributefactory.cpp
 *    Nodal
 *
 *    Created by Aidan Lane on Tue May 24 2005.
 *    Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "diagramelementattributefactory.h"

#include <QByteArray>

#include "diagramelementciderinfo.h"
#include "diagramelementcomment.h"
#include "diagramelementink.h"
#include "diagramelementlabel.h"
#include "diagramelementorigin.h"
#include "diagramelementpolygon.h"
#include "diagramelementpos.h"
#include "diagramelementrect.h"
#include "diagramelementshape.h"
#include "diagramelementsize.h"


#define RETURN_VALUE( VALUE, METHOD, PRE, POST, DEFAULT ) {	\
    if ( VALUE == DiagramElementCiderInfo::METHOD )		\
      return PRE DiagramElementCiderInfo POST;			\
    else if ( VALUE == DiagramElementComment::METHOD )		\
      return PRE DiagramElementComment POST;			\
    else if ( VALUE == DiagramElementInk::METHOD )		\
      return PRE DiagramElementInk POST;			\
    else if ( VALUE == DiagramElementLabel::METHOD )		\
      return PRE DiagramElementLabel POST;			\
    else if ( VALUE == DiagramElementOrigin::METHOD )		\
      return PRE DiagramElementOrigin POST;			\
    else if ( VALUE == DiagramElementPolygon::METHOD )		\
      return PRE DiagramElementPolygon POST;			\
    else if ( VALUE == DiagramElementPos::METHOD )		\
      return PRE DiagramElementPos POST;			\
    else if ( VALUE == DiagramElementRect::METHOD )		\
      return PRE DiagramElementRect POST;			\
    else if ( VALUE == DiagramElementShape::METHOD )		\
      return PRE DiagramElementShape POST;			\
    else if ( VALUE == DiagramElementSize::METHOD )		\
      return PRE DiagramElementSize POST;			\
    return DEFAULT;						\
  }


AbstractElementAttribute*
DiagramElementAttributeFactory::create( MvcDiagram::ElementAttributeType type,
					AbstractElement* parent )
{
  RETURN_VALUE( type, classType(), new, (parent), 0 );
}


/*!
 * Note: This method is (intentionally) NOT case sensitive when it performs the
 *       key matching.
 */
AbstractElementAttribute*
DiagramElementAttributeFactory::create( const QByteArray& key,
					AbstractElement* parent )
{
  const QByteArray lowerKey = key.toLower(); // cache it
  RETURN_VALUE( lowerKey, classKey().toLower(), new, (parent), 0 );
}


/*!
 * Warning! This method is not thread-safe until it returns from the first call.
 */
const QList<QByteArray>& DiagramElementAttributeFactory::keys()
{
  static QList<QByteArray> list;

  if ( list.isEmpty() ) {
    list << DiagramElementCiderInfo::classKey()
	 << DiagramElementComment::classKey()
	 << DiagramElementInk::classKey()
	 << DiagramElementLabel::classKey()
	 << DiagramElementOrigin::classKey()
	 << DiagramElementPolygon::classKey()
	 << DiagramElementPos::classKey()
	 << DiagramElementRect::classKey()
	 << DiagramElementShape::classKey()
	 << DiagramElementSize::classKey();
  }

  return list;
}


int DiagramElementAttributeFactory::type( const QByteArray& key )
{
  const QByteArray lowerKey = key.toLower(); // cache it
  RETURN_VALUE( lowerKey, classKey().toLower(), , ::classType(), 0 );
}


const QString& DiagramElementAttributeFactory::title( const QByteArray& key )
{
  static const QString s_nullString;
  const QByteArray lowerKey = key.toLower(); // cache it
  RETURN_VALUE( lowerKey, classKey().toLower(), , ::classTitle(), s_nullString );
}
