/*  -*- c++ -*-  (for Emacs)
 *
 *  diagramelementattributefactory.h
 *  Digest
 * 
 *  Imported into Digest by Aidan Lane on Thu Jun 9 2005.
 *  Modifications Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  Nodal file:
 *
 *    parcattributefactory.h
 *    Nodal
 *
 *    Created by Aidan Lane on Tue May 24 2005.
 *    Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIAGRAMELEMENTATTRIBUTEFACTORY_H
#define DIAGRAMELEMENTATTRIBUTEFACTORY_H


#include <QList>

#include "abstractdiagramelementattribute.h"

class QByteArray;


/*! \brief The DiagramElementAttributeFactory class creates
 *         AbstractDiagramElementAttribute objects for
 *         AbstractElement objects.
 *
 * Note that QByteArray is more than enough for keys.
 * There is no need for QString, and we definitely don't want the keys to be
 * language dependant.
 *
 * Also on the topic of QByteArray, from the Qt 4.0.0 documentation:
 * "Using QByteArray is much more convenient than using const char *.
 * Behind the scenes, it always ensures that the data is followed by a '\\0'
 * terminator, and uses implicit sharing (copy-on-write) to reduce memory
 * usage and avoid needless copying of data."
 */
class DiagramElementAttributeFactory {

public:
  static AbstractElementAttribute* create( MvcDiagram::ElementAttributeType type,
					   AbstractElement* parent );
  static AbstractElementAttribute* create( const QByteArray& key,
					   AbstractElement* parent );
  static const QList<QByteArray>& keys();
  static int type( const QByteArray& key );
  static const QString& title( const QByteArray& key );
};


#endif // ! DIAGRAMELEMENTATTRIBUTEFACTORY_H
