/*
 *  diagramelementcomment.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 13 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "diagramelementcomment.h"

#include <QByteArray>


DiagramElementComment::DiagramElementComment( AbstractElement* parent,
					      const QString& comment )
  : AbstractDiagramElementAttribute(parent),
    m_comment(comment)
{}


QString DiagramElementComment::worker_toString() const {
  return m_comment;
}

bool DiagramElementComment::worker_setData( const QString& data ) {
  m_comment = data;
  return true;
}

QVariant DiagramElementComment::worker_toVariant() const {
  return m_comment;
}

bool DiagramElementComment::worker_setData( const QVariant& data ) {
  m_comment = data.toString();
  return true;
}
