/*  -*- c++ -*-  (for Emacs)
 *
 *  diagramelementcomment.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 13 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIAGRAMELEMENTCOMMENT_H
#define DIAGRAMELEMENTCOMMENT_H


#include "abstractdiagramelementattribute.h"


/*!
 * This is a comment attribute that can be added to an AbstractDiagramElement.
 */
class DiagramElementComment : public AbstractDiagramElementAttribute {

 public:
  DiagramElementComment( AbstractElement* parent,
			 const QString& comment = tr("Comment") );

  DECLARE_CLASS_TYPE( MvcDiagram::DEA_Comment );
  DECLARE_CLASS_KEY( "comment" );
  DECLARE_CLASS_TITLE( "Comment" );

  const QString& comment() const { return m_comment; }
  void setComment( const QString& comment ) { m_comment = comment; }

protected:
  QString  worker_toString()  const;
  bool     worker_setData( const QString& data );
  QVariant worker_toVariant() const;
  bool     worker_setData( const QVariant& data );

 private:
  QString m_comment;
};


#endif // ! DIAGRAMELEMENTCOMMENT_H
