/*  -*- c++ -*-  (for Emacs)
 *
 *  diagramelementink.h
 *  Digest
 * 
 *  Created by Aidan Lane on Wed Sep 7 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIAGRAMELEMENTINK_H
#define DIAGRAMELEMENTINK_H


#include "abstractdiagramelementattribute.h"

#include "Gesture/strokelist.h"


/*!
 * This is an ink attribute that can be added to an AbstractDiagramElement.
 */
class DiagramElementInk : public AbstractDiagramElementAttribute {

public:
  DiagramElementInk( AbstractElement* parent,
		     const StrokeList& ink = StrokeList() );

  DECLARE_CLASS_TYPE( MvcDiagram::DEA_Ink );
  DECLARE_CLASS_KEY( "ink" );
  DECLARE_CLASS_TITLE( "Ink" );

  const StrokeList& ink() const { return m_ink; }
  void setInk( const StrokeList& ink ) { m_ink = ink; }

protected:
  QString  worker_toString()  const;
  bool     worker_setData( const QString& data );
  QVariant worker_toVariant() const;
  bool     worker_setData( const QVariant& data );

private:
  StrokeList m_ink;
};


#endif // ! DIAGRAMELEMENTINK_H
