/*  -*- c++ -*-  (for Emacs)
 *
 *  diagramelementlabel.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 10 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIAGRAMELEMENTLABEL_H
#define DIAGRAMELEMENTLABEL_H


#include "abstractdiagramelementattribute.h"


/*!
 * This is a label attribute that can be added to an AbstractDiagramElement.
 */
class DiagramElementLabel : public AbstractDiagramElementAttribute {

public:
  DiagramElementLabel( AbstractElement* parent,
		       const QString& label = tr("Label") );

  DECLARE_CLASS_TYPE( MvcDiagram::DEA_Label );
  DECLARE_CLASS_KEY( "label" );
  DECLARE_CLASS_TITLE( "Label" );

  const QString& label() const { return m_label; }
  void setLabel( const QString& label ) { m_label = label; }

protected:
  QString  worker_toString()  const;
  bool     worker_setData( const QString& data );
  QVariant worker_toVariant() const;
  bool     worker_setData( const QVariant& data );

private:
  QString m_label;
};


#endif // ! DIAGRAMELEMENTLABEL_H
