/*
 *  diagramelementorigin.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Oct 06 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "diagramelementorigin.h"

#include <QByteArray>
#include <QStringList>


DiagramElementOrigin::DiagramElementOrigin( AbstractElement* parent,
					    const QPointF& origin )
  : AbstractDiagramElementAttribute(parent),
    m_origin(origin)
{}


QString DiagramElementOrigin::worker_toString() const {
  return ( QString::number(m_origin.x())
	   + ","
	   + QString::number(m_origin.y()) );
}


bool DiagramElementOrigin::worker_setData( const QString& data )
{
  QStringList coords = data.split( "," );

  if ( coords.size() == 2 ) {
    bool ok = false;
    m_origin.setX( coords.at(0).toFloat(&ok) );
    if ( !ok ) return false;
    m_origin.setY( coords.at(1).toFloat(&ok) );
    if ( !ok ) return false;
    return true;
  }

  return false;
}


QVariant DiagramElementOrigin::worker_toVariant() const {
  return QVariant::fromValue( m_origin );
}


bool DiagramElementOrigin::worker_setData( const QVariant& data ) {
  m_origin = data.toPointF();
  return true;
}
