/*  -*- c++ -*-  (for Emacs)
 *
 *  diagramelementorigin.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Oct 06 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIAGRAMELEMENTORIGIN_H
#define DIAGRAMELEMENTORIGIN_H


#include "abstractdiagramelementattribute.h"

#include <QPointF>


/*!
 * This is an origin attribute that can be added to an AbstractDiagramElement.
 */
class DiagramElementOrigin : public AbstractDiagramElementAttribute {

public:
  DiagramElementOrigin( AbstractElement* parent,
		      const QPointF& origin = QPointF() );

  DECLARE_CLASS_TYPE( MvcDiagram::DEA_Origin );
  DECLARE_CLASS_KEY( "origin" );
  DECLARE_CLASS_TITLE( "Origin" );

  const QPointF& origin() const { return m_origin; }
  void setOrigin( const QPointF& origin ) { m_origin = origin; }

protected:
  QString  worker_toString()  const;
  bool     worker_setData( const QString& data );
  QVariant worker_toVariant() const;
  bool     worker_setData( const QVariant& data );

private:
  QPointF m_origin;
};


#endif // ! DIAGRAMELEMENTORIGIN_H
