/*  -*- c++ -*-  (for Emacs)
 *
 *  diagramelementpos.h
 *  Digest
 * 
 *  Created by Aidan Lane on Wed Sep 28 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIAGRAMELEMENTPOS_H
#define DIAGRAMELEMENTPOS_H


#include "abstractdiagramelementattribute.h"

#include <QPointF>


/*!
 * This is a position attribute that can be added to an AbstractDiagramElement.
 */
class DiagramElementPos : public AbstractDiagramElementAttribute {

public:
  DiagramElementPos( AbstractElement* parent,
		      const QPointF& pos = QPointF() );

  DECLARE_CLASS_TYPE( MvcDiagram::DEA_Pos );
  DECLARE_CLASS_KEY( "pos" );
  DECLARE_CLASS_TITLE( "Position" );

  const QPointF& pos() const { return m_pos; }
  void setPos( const QPointF& pos ) { m_pos = pos; }

protected:
  QString  worker_toString()  const;
  bool     worker_setData( const QString& data );
  QVariant worker_toVariant() const;
  bool     worker_setData( const QVariant& data );

private:
  QPointF m_pos;
};


#endif // ! DIAGRAMELEMENTPOS_H
