/*
 *  diagramelementrect.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 13 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURRECTE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "diagramelementrect.h"

#include <QByteArray>
#include <QStringList>


DiagramElementRect::DiagramElementRect( AbstractElement* parent,
					const QRectF& rect )
  : AbstractDiagramElementAttribute(parent),
    m_rect(rect)
{}


QString DiagramElementRect::worker_toString() const {
  return ( QString::number(m_rect.left())
	   + ","
	   + QString::number(m_rect.top())
	   + ","
	   + QString::number(m_rect.right())
	   + ","
	   + QString::number(m_rect.bottom()) );
}


bool DiagramElementRect::worker_setData( const QString& data )
{
  QStringList coords = data.split( "," );

  if ( coords.size() == 4 )
    {
      bool ok = false;

      m_rect.setLeft( coords.at(0).toFloat(&ok) );
      if ( !ok ) return false;
      m_rect.setTop( coords.at(1).toFloat(&ok) );
      if ( !ok ) return false;
      m_rect.setRight( coords.at(2).toFloat(&ok) );
      if ( !ok ) return false;
      m_rect.setBottom( coords.at(3).toFloat(&ok) );
      if ( !ok ) return false;

      return true;
    }

  return false;
}


QVariant DiagramElementRect::worker_toVariant() const {
  return QVariant::fromValue( m_rect );
}


bool DiagramElementRect::worker_setData( const QVariant& data ) {
  m_rect = data.toRectF();
  return m_rect.isValid();
}
