/*  -*- c++ -*-  (for Emacs)
 *
 *  diagramelementrect.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 13 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURRECTE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIAGRAMELEMENTRECT_H
#define DIAGRAMELEMENTRECT_H


#include "abstractdiagramelementattribute.h"

#include <QRectF>


/*!
 * This is a rectangle attribute that can be added to an AbstractDiagramElement.
 */
class DiagramElementRect : public AbstractDiagramElementAttribute {

public:
  DiagramElementRect( AbstractElement* parent,
		      const QRectF& rect = QRectF() );

  DECLARE_CLASS_TYPE( MvcDiagram::DEA_Rect );
  DECLARE_CLASS_KEY( "rect" );
  DECLARE_CLASS_TITLE( "Bounding Rectangle" );

  const QRectF& rect() const { return m_rect; }
  void setRect( const QRectF& rect ) { m_rect = rect; }

protected:
  QString  worker_toString()  const;
  bool     worker_setData( const QString& data );
  QVariant worker_toVariant() const;
  bool     worker_setData( const QVariant& data );

private:
  QRectF m_rect;
};


#endif // ! DIAGRAMELEMENTRECT_H
