/*
 *  diagramelementshape.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 13 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURRECTE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "diagramelementshape.h"

#include <QByteArray>
#include <QStringList>


DiagramElementShape::DiagramElementShape( AbstractElement* parent, Type shape )
  : AbstractDiagramElementAttribute(parent),
    m_shape(shape)
{}


QString DiagramElementShape::worker_toString() const {
  return QString::number( m_shape );
}


bool DiagramElementShape::worker_setData( const QString& data ) {
  bool intOk = false;
  m_shape = (Type)data.toInt(&intOk);
  return intOk;
}


QVariant DiagramElementShape::worker_toVariant() const {
  return QVariant( m_shape );
}


bool DiagramElementShape::worker_setData( const QVariant& data ) {
  bool intOk = false;
  m_shape = (Type)data.toInt(&intOk);
  return intOk;
}
