/*  -*- c++ -*-  (for Emacs)
 *
 *  diagramelementshape.h
 *  Digest
 * 
 *  Created by Aidan Lane on Tue Aug 23 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURRECTE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIAGRAMELEMENTSHAPE_H
#define DIAGRAMELEMENTSHAPE_H


#include "abstractdiagramelementattribute.h"


/*!
 * This is a rectition attribute that can be added to an AbstractDiagramElement.
 */
class DiagramElementShape : public AbstractDiagramElementAttribute {

public:
  enum Type {  // explicit numbering to help when making changes in the future:
    Circle          = 0,
    Oval            = 1,
    Square          = 2,
    Rectangle       = 3,
    UprightTriangle = 4,
    Diamond         = 5
  };

  DiagramElementShape( AbstractElement* parent, Type shape = Circle );

  DECLARE_CLASS_TYPE( MvcDiagram::DEA_Shape );
  DECLARE_CLASS_KEY( "shape" );
  DECLARE_CLASS_TITLE( "Shape" );

  Type shape() const { return m_shape; }
  void setShape( Type shape ) { m_shape = shape; }

protected:
  QString  worker_toString()  const;
  bool     worker_setData( const QString& data );
  QVariant worker_toVariant() const;
  bool     worker_setData( const QVariant& data );

private:
  Type m_shape;
};


#endif // ! DIAGRAMELEMENTSHAPE_H
