/*
 *  diagramelementsize.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Oct 06 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "diagramelementsize.h"

#include <QByteArray>
#include <QStringList>


DiagramElementSize::DiagramElementSize( AbstractElement* parent,
					const QSizeF& size )
  : AbstractDiagramElementAttribute(parent),
    m_size(size)
{}


QString DiagramElementSize::worker_toString() const {
  return ( QString::number(m_size.width())
	   + ","
	   + QString::number(m_size.height()) );
}


bool DiagramElementSize::worker_setData( const QString& data )
{
  QStringList vals = data.split( "," );

  if ( vals.size() == 2 ) {
    bool ok = false;
    m_size.setWidth( vals.at(0).toFloat(&ok) );
    if ( !ok ) return false;
    m_size.setHeight( vals.at(1).toFloat(&ok) );
    if ( !ok ) return false;
    return true;
  }

  return false;
}


QVariant DiagramElementSize::worker_toVariant() const {
  return QVariant::fromValue( m_size );
}


bool DiagramElementSize::worker_setData( const QVariant& data ) {
  m_size = data.toSizeF();
  return true;
}
