/*  -*- c++ -*-  (for Emacs)
 *
 *  diagram.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 13 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "diagram.h"

#include <QByteArray>

#include "abstractdiagramelement.h"
#include "diagramcontroller.h"
#include "diagramelementfactory.h"


Diagram::Diagram( QObject* parent )
  : ElementDoc(parent)
{
}

Diagram::Diagram( const QString& name, QObject* parent )
  : ElementDoc(name, parent)
{
}


/*!
 * Convenience method.
 *
 * Returns a cached guarded pointer that has been dynamically cast to
 * DiagramController* from AbstractController*.
 *
 * See also AbstractModel::controller().
 */
DiagramController* Diagram::diagramController() const {
  return c_diagramController;
}


/*!
 * Re-implemented, as to also have the pointer returned by diagramController()
 * updated.
 *
 * Asserts that the \em event is non-null.
 */
void Diagram::changeControllerEvent( MChangeControllerEvent* event )
{
  Q_ASSERT( event != 0 );
  ElementDoc::changeControllerEvent( event );
  c_diagramController
    = ( (event->controller()==0)
	? 0
	: qobject_cast<DiagramController*>(event->controller()->objectPtr()) );
}


AbstractElement* Diagram::createElement( const QByteArray& key,
					    quint32 instanceId ) {
  return DiagramElementFactory::create( key, instanceId, this );
}
