/*  -*- c++ -*-  (for Emacs)
 *
 *  diagram.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 13 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIAGRAM_H
#define DIAGRAM_H


#include "MvcCore/elementdoc.h"

#include "mvcdiagram.h"

class DiagramController;


class Diagram : public ElementDoc {

  Q_OBJECT

public:
  Diagram( QObject* parent = 0 );
  Diagram( const QString& name, QObject* parent );

  DECLARE_CLASS_KEY( "diagram" );

  DiagramController* diagramController() const;

  /*! Returns MvcDiagram::id(). */
  inline static MvcModuleId_t classModuleId() { return MvcDiagram::id(); }
  /*! Returns classModuleId(). */
  virtual MvcModuleId_t moduleId() const { return classModuleId(); }


protected:
  virtual void changeControllerEvent( MChangeControllerEvent* event );

  virtual AbstractElement* createElement( const QByteArray& key,
					     quint32 instanceId );

private:
  // Temporary caches:
  QPointer<DiagramController> c_diagramController;
};


#endif  // ! DIAGRAM_H
