/*  -*- c++ -*-  (for Emacs)
 *
 *  abstractdiagramelement.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 13 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef ABSTRACTDIAGRAMELEMENT_H
#define ABSTRACTDIAGRAMELEMENT_H


#include "MvcCore/abstractelement.h"

#include <QPointF>
#include <QSet>
#include <QStringList>

#include "diagramelementevents.h"
#include "mvcdiagram.h" // used by sub-classes to fetch element types


/*!
 * Warning! Control points are only used for editing purposes.
 *          All persistent data (other than the name) is kept in the
 *          attributes.
 */
class AbstractDiagramElement : public AbstractElement {

public:
  enum ControlPointEditFlag {
    NoEditingAllowed   = 0x0,  /*! No control point editing is allowed. */
    InsertionIsAllowed = 0x1,  /*! Control points can be inserted.      */
    RemovalIsAllowed   = 0x2,  /*! Control points can be removed.       */
    MovementIsAllowed  = 0x4,  /*! Control points can be moved.         */
  };
  Q_DECLARE_FLAGS( ControlPointEditFlags, ControlPointEditFlag ); // typesafe flags

  static ControlPointEditFlags classControlPointEditFlags() {
    return NoEditingAllowed;
  }
  virtual ControlPointEditFlags controlPointEditFlags() const = 0;

  /*!
   * Warning! Control points are only used for editing purposes.
   *          All persistent data (other than the name) is kept in the
   *          attributes.
   */
  const QList<QPointF>& controlPoints() const { return m_controlPoints; }

  virtual const QSet<int>& requiredAttributes() const = 0;
  virtual const QSet<int>& additionalAttributes() const = 0;


protected:
  AbstractDiagramElement( qint32 instanceId, ElementDoc* doc,
			  const QList<QPointF>& controlPoints = QList<QPointF>() );
  AbstractDiagramElement( ElementDoc* doc,
			  const QList<QPointF>& controlPoints = QList<QPointF>() );

  void addRequiredAttributes();

  virtual void dispatchEvent( MEvent* );

  virtual void controlPointInsertEvent( MEControlPointInsertEvent* );
  virtual void controlPointRemoveEvent( MEControlPointRemoveEvent* );
  virtual void controlPointMoveEvent( MEControlPointMoveEvent* );

  virtual AbstractElementAttribute* createAttribute( int type );
  virtual AbstractElementAttribute* createAttribute( const QByteArray& key );
  virtual int attributeKeyToType( const QByteArray& key );

  // The following is intentionally NOT private in the name of efficiency and
  // simplification of implementation of sub-classes.
  QList<QPointF> m_controlPoints;
};

Q_DECLARE_OPERATORS_FOR_FLAGS( AbstractDiagramElement::ControlPointEditFlags );


#endif  // ! ABSTRACTDIAGRAMELEMENT_H
