/*  -*- c++ -*-  (for Emacs)
 *
 *  diagramelementevents.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 14 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIAGRAMELEMENTEVENTS_H
#define DIAGRAMELEMENTEVENTS_H


#include "MvcCore/elementevents.h"
#include "MvcCore/genericcontainers.h"

#include "mvcdiagram.h"
#include "diagramcontainers.h"


class MEDiagramElementEvent : public MEElementEvent {
public:
  enum Type {
    ControlPointInsert  = MEElementEvent::User,
    ControlPointRemove,
    ControlPointMove,
    User                = MEElementEvent::User + 1000
  };

  MEDiagramElementEvent( Type type )
    : MEElementEvent((MEElementEvent::Type)type) {}

  /*! Returns MvcDiagram::id(). */
  inline static MvcModuleId_t classModuleId() { return MvcDiagram::id(); }
  /*! Returns classModuleId(). */
  virtual MvcModuleId_t moduleId() const { return classModuleId(); }
};


/*!
 * Note: \em int has been used, not \em quint32, as it's what Qt has been
 *       standardised on for its indices.
 */
class MEControlPointEvent : public MEDiagramElementEvent,
			    public IndexContainer {
public:
  MEControlPointEvent( Type type, int index )
    : MEDiagramElementEvent(type),
      IndexContainer(index) {}
};


class MEControlPointInsertEvent : public MEControlPointEvent,
				  public ControlPointContainer {
public:
  MEControlPointInsertEvent( int index, const QPointF& pos )
    : MEControlPointEvent(ControlPointInsert, index),
      ControlPointContainer(pos) {}
};


/*!
 * Convenience and consistency class.
 *
 * This is merely MEControlPointEvent with the type set to
 * MEControlPointEvent::Remove.
 * However, since there needs to be a class for Insert and Move,
 * having this class keeps the interface consistent.
 */
class MEControlPointRemoveEvent : public MEControlPointEvent {
public:
  MEControlPointRemoveEvent( int index )
    : MEControlPointEvent(ControlPointRemove, index) {}
};


class MEControlPointMoveEvent : public MEControlPointEvent,
				public ControlPointContainer {
public:
  MEControlPointMoveEvent( int index, const QPointF& pos )
    : MEControlPointEvent(ControlPointMove, index),
      ControlPointContainer(pos) {}
};


#endif //  ! DIAGRAMELEMENTEVENTS_H
