/*
 *  diagramelementfactory.cpp
 *  Digest
 * 
 *  Imported into Digest by Aidan Lane on Thu Jun 9 2005.
 *  Modifications Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  Nodal file:
 *
 *    parcattributefactory.cpp
 *    Nodal
 *
 *    Created by Aidan Lane on Tue May 24 2005.
 *    Copyright (c) 2005 CEMA, Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "diagramelementfactory.h"

#include <QByteArray>

#include "MvcCore/elementdoc.h"

#include "diagramgesture.h"
#include "diagrampolygon.h"
#include "diagrampolyline.h"
#include "diagramshape.h"
#include "diagramtext.h"


#define RETURN_VALUE( VALUE, METHOD, PRE, POST, DEFAULT  ) {	\
    if ( VALUE == DiagramGesture::METHOD )			\
      return PRE DiagramGesture POST;				\
    else if ( VALUE == DiagramPolygon::METHOD )			\
      return PRE DiagramPolygon POST;				\
    else if ( VALUE == DiagramPolyline::METHOD )		\
      return PRE DiagramPolyline POST;				\
    else if ( VALUE == DiagramShape::METHOD )			\
      return PRE DiagramShape POST;				\
    else if ( VALUE == DiagramText::METHOD )			\
      return PRE DiagramText POST;				\
    return DEFAULT;						\
  }


AbstractDiagramElement*
DiagramElementFactory::create( MvcDiagram::ElementType type,
			       qint32 instanceId,
			       ElementDoc* parent )
{
  RETURN_VALUE( type, classType(), new, (instanceId, parent), 0 );
}


/*!
 * This is an overloaded member function, provided for convenience.
 * It behaves essentially like the above function.
 *
 * The new element's instance ID will be automatically generated using
 * ElementDoc::genElementInstanceId().
 *
 * Asserts that \em parent is non-null.
 */
AbstractDiagramElement*
DiagramElementFactory::create( MvcDiagram::ElementType type,
			       ElementDoc* parent )
{
  Q_ASSERT( parent != 0 );
  return create( type, parent->genElementInstanceId(), parent );
}


/*!
 * Note: This method is (intentionally) NOT case sensitive when it performs the
 *       key matching.
 */
AbstractDiagramElement*
DiagramElementFactory::create( const QByteArray& key,
			       qint32 instanceId,
			       ElementDoc* parent ) {
  const QByteArray lowerKey = key.toLower(); // cache it
  RETURN_VALUE( lowerKey, classKey().toLower(), new, (instanceId, parent), 0 );
}


/*!
 * This is an overloaded member function, provided for convenience.
 * It behaves essentially like the above function.
 *
 * The new element's instance ID will be automatically generated using
 * ElementDoc::genElementInstanceId().
 *
 * Asserts that \em parent is non-null.
 */
AbstractDiagramElement*
DiagramElementFactory::create( const QByteArray& key,
			       ElementDoc* parent ) {
  Q_ASSERT( parent != 0 );
  return create( key, parent->genElementInstanceId(), parent );
}


/*!
 * Warning! This method is not thread-safe until it returns from the first call.
 */
const QList<QByteArray>& DiagramElementFactory::keys()
{
  static QList<QByteArray> list;

  if ( list.isEmpty() ) {
    list << DiagramGesture::classKey()
	 << DiagramPolygon::classKey()
	 << DiagramPolyline::classKey()
	 << DiagramShape::classKey()
	 << DiagramText::classKey();
  }

  return list;
}


int DiagramElementFactory::type( const QByteArray& key ) {
  const QByteArray lowerKey = key.toLower(); // cache it
  RETURN_VALUE( lowerKey, classKey().toLower(), , ::classType(), 0 );
}


const QString& DiagramElementFactory::title( const QByteArray& key ) {
  static const QString s_nullString;
  const QByteArray lowerKey = key.toLower(); // cache it
  RETURN_VALUE( lowerKey, classKey().toLower(), , ::classTitle(), s_nullString );
}
