/*
 *  diagramgesture.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 13 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "diagramgesture.h"


DiagramGesture::DiagramGesture( qint32 instanceId, ElementDoc* doc )
  : AbstractDiagramElement(instanceId, doc)
{
  addRequiredAttributes();
}


DiagramGesture::DiagramGesture( ElementDoc* doc )
  : AbstractDiagramElement(doc)
{
  addRequiredAttributes();
}


/*!
 * Warning! This method is not thread-safe until it returns from the first call.
 */
const QSet<int>& DiagramGesture::classRequiredAttributes()
{
  static QSet<int> set;
  if ( set.isEmpty() ) {
    set << MvcDiagram::DEA_Ink
	<< MvcDiagram::DEA_Origin;
  }
  return set;
}


/*!
 * Warning! This method is not thread-safe until it returns from the first call.
 */
const QSet<int>& DiagramGesture::classAdditionalAttributes()
{
  static QSet<int> set;
  if ( set.isEmpty() ) {
    set << MvcDiagram::DEA_Comment;
  }
  return set;
}


/*!
 * Note: event->index() must be a valid index position in the conrtrol point list
 *       (i.e., 0 <= event->index() < controlPoints().size()).
 */
void DiagramGesture::controlPointMoveEvent( MEControlPointMoveEvent* event )
{
  Q_ASSERT( event != 0 );

  AbstractDiagramElement::controlPointMoveEvent( event ); // move point

  // TODO: update the rect attribute!
}
