/*  -*- c++ -*-  (for Emacs)
 *
 *  diagrampolygon.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 13 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIAGRAMPOLYGON_H
#define DIAGRAMPOLYGON_H


#include "abstractdiagramelement.h"


class DiagramPolygon : public AbstractDiagramElement {

public:
  DiagramPolygon( qint32 instanceId, ElementDoc* doc );
  DiagramPolygon( ElementDoc* doc );

  DECLARE_CLASS_TYPE( MvcDiagram::DE_Polygon );
  DECLARE_CLASS_KEY( "polygon" );
  DECLARE_CLASS_TITLE( "Polygon" );

  static ControlPointEditFlags classControlPointEditFlags() {
    return ( InsertionIsAllowed
	     | RemovalIsAllowed
	     | MovementIsAllowed );
  }
  ControlPointEditFlags controlPointEditFlags() const {
    return classControlPointEditFlags();
  }

  static const QSet<int>& classRequiredAttributes();
  const QSet<int>& requiredAttributes() const {
    return classRequiredAttributes();
  }

  static const QSet<int>& classAdditionalAttributes();
  const QSet<int>& additionalAttributes() const {
    return classAdditionalAttributes();
  }
  

protected:
  void controlPointInsertEvent( MEControlPointInsertEvent* );
  void controlPointRemoveEvent( MEControlPointRemoveEvent* );
  void controlPointMoveEvent( MEControlPointMoveEvent* );
};


#endif  // ! DIAGRAMPOLYGON_H
