/*
 *  diagramshape.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 13 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "diagramshape.h"


DiagramShape::DiagramShape( qint32 instanceId, ElementDoc* doc,
			    DiagramElementShape::Type shape,
			    const QPointF& origin,
			    const QSizeF& size )
  : AbstractDiagramElement(instanceId, doc)
{
  init( shape, origin, size );
}


DiagramShape::DiagramShape( ElementDoc* doc,
			    DiagramElementShape::Type shape,
			    const QPointF& origin,
			    const QSizeF& size )
  : AbstractDiagramElement(doc)
{
  init( shape, origin, size );
}


/*!
 * Initialises the element with the given \em shape, \em origin and \em size.
 *
 * It is important that the element can have it's classRequiredAttributes()
 * set before it is used, as they would otherwise be invalid when the editor
 * receives its elementAddedEvent() and then the user would see it as it's
 * initialised. Also, if the attribute values were initially invalid, an event
 * may be triggered before we have a change to correct it (e.g. use with the
 * CIDER smart diagramming environment toolkit). Finally, this approach is
 * more efficient, as it doesn't require as many events to be posted.
 */
void DiagramShape::init( DiagramElementShape::Type shape,
			 const QPointF& origin,
			 const QSizeF& size )
{
  addRequiredAttributes();

  AbstractElementAttribute* shape_a  = attribute( MvcDiagram::DEA_Shape );
  AbstractElementAttribute* origin_a = attribute( MvcDiagram::DEA_Origin );
  AbstractElementAttribute* size_a   = attribute( MvcDiagram::DEA_Size );
  Q_ASSERT( shape_a != 0 );
  Q_ASSERT( origin_a != 0 );
  Q_ASSERT( size_a != 0 );
  shape_a->setData( shape );
  origin_a->setData( origin );
  size_a->setData( size );
}


/*!
 * Warning! This method is not thread-safe until it returns from the first call.
 */
const QSet<int>& DiagramShape::classRequiredAttributes()
{
  static QSet<int> set;
  if ( set.isEmpty() ) {
    set << MvcDiagram::DEA_Origin
	<< MvcDiagram::DEA_Shape
	<< MvcDiagram::DEA_Size;
  }
  return set;
}


/*!
 * Warning! This method is not thread-safe until it returns from the first call.
 */
const QSet<int>& DiagramShape::classAdditionalAttributes()
{
  static QSet<int> set;
  if ( set.isEmpty() ) {
    set << MvcDiagram::DEA_Comment;
  }
  return set;
}


/*!
 * Note: event->index() must be a valid index position in the conrtrol point list
 *       (i.e., 0 <= event->index() < controlPoints().size()).
 */
void DiagramShape::controlPointMoveEvent( MEControlPointMoveEvent* event )
{
  Q_ASSERT( event != 0 );

  AbstractDiagramElement::controlPointMoveEvent( event ); // move point

  // TODO: update the rect attribute!
}
