/*
 *  diagramtext.cpp
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 13 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "diagramtext.h"

#include "abstractelementattribute.h"


DiagramText::DiagramText( qint32 instanceId, ElementDoc* doc,
			  const QString& label,
			  const QPointF& origin,
			  const QSizeF& size )
  : AbstractDiagramElement(instanceId, doc)
{ 
  init( label, origin, size );
}


DiagramText::DiagramText( ElementDoc* doc,
			  const QString& label,
			  const QPointF& origin,
			  const QSizeF& size )
  : AbstractDiagramElement(doc)
{
  init( label, origin, size );
}


/*!
 * Initialises the element with the given \em label, \em origin and \em size.
 *
 * It is important that the element can have it's classRequiredAttributes()
 * set before it is used, as they would otherwise be invalid when the editor
 * receives its elementAddedEvent() and then the user would see it as it's
 * initialised. Also, if the attribute values were initially invalid, an event
 * may be triggered before we have a change to correct it (e.g. use with the
 * CIDER smart diagramming environment toolkit). Finally, this approach is
 * more efficient, as it doesn't require as many events to be posted.
 */
void DiagramText::init( const QString& label,
			const QPointF& origin,
			const QSizeF& size )
{
  addRequiredAttributes();

  AbstractElementAttribute* label_a  = attribute( MvcDiagram::DEA_Label );
  AbstractElementAttribute* origin_a = attribute( MvcDiagram::DEA_Origin );
  AbstractElementAttribute* size_a   = attribute( MvcDiagram::DEA_Size );
  Q_ASSERT( label_a != 0 );
  Q_ASSERT( origin_a != 0 );
  Q_ASSERT( size_a != 0 );
  label_a->setData( label );
  origin_a->setData( origin );
  size_a->setData( size );
}


/*!
 * Warning! This method is not thread-safe until it returns from the first call.
 */
const QSet<int>& DiagramText::classRequiredAttributes()
{
  static QSet<int> set;
  if ( set.isEmpty() ) {
    set << MvcDiagram::DEA_Label
	<< MvcDiagram::DEA_Origin
	<< MvcDiagram::DEA_Size;
  }
  return set;
}


/*!
 * Warning! This method is not thread-safe until it returns from the first call.
 */
const QSet<int>& DiagramText::classAdditionalAttributes()
{
  static QSet<int> set;
  if ( set.isEmpty() ) {
    set << MvcDiagram::DEA_Comment;
  }
  return set;
}


/*!
 * Note: event->index() must be a valid index position in the conrtrol point list
 *       (i.e., 0 <= event->index() < controlPoints().size()).
 */
void DiagramText::controlPointMoveEvent( MEControlPointMoveEvent* event )
{
  Q_ASSERT( event != 0 );

  AbstractDiagramElement::controlPointMoveEvent( event ); // move point

  // TODO: update the pos attribute!
}
