/*  -*- c++ -*-  (for Emacs)
 *
 *  mvcdiagram.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Aug 26 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef MVCDIAGRAM_H
#define MVCDIAGRAM_H


#include "MvcCore/mvccore.h"


/* Enable QPolygonF to be used in QVariant, as Qt does not do this for us.
 * The registration is actually performed by DiagramElementPolygon, but
 * don't want to include its header explicitly everywhere.
 */
#include <QPolygonF>
Q_DECLARE_METATYPE( QPolygonF );


class MvcDiagram : public MvcCore {

public:
  enum ElementType {
    DE_Gesture   = MvcCore::UserElement,
    DE_Polygon,
    DE_Polyline,
    DE_Shape,
    DE_Text,
    UserElement  = MvcCore::UserElement + 1000
  };

  enum ElementAttributeType {
    DEA_CiderInfo        = MvcCore::UserElementAttribute,//TODO: move me to Digest -> it's application specific!
    DEA_Comment,
    DEA_Ink,
    DEA_Label,
    DEA_Origin,
    DEA_Polygon,
    DEA_Pos,
    DEA_Rect,
    DEA_Shape,
    DEA_Size,
    UserElementAttribute = MvcCore::UserElementAttribute + 1000
  };

  inline static MvcModuleId_t id() {
    static MvcModuleId_t s_id = generateNewId();
    return s_id;
  }
};


#endif  // ! MVCDIAGRAM_H
