/*  -*- c++ -*-  (for Emacs)
 *
 *  abstractdiagramview.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Jun 15 2005.
 *  Copyright (c) 2005 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef ABSTRACTDIAGRAMVIEW_H
#define ABSTRACTDIAGRAMVIEW_H


#include "MvcCore/abstractelementdocview.h"

#include "diagramviewevents.h"


class Diagram;
class DiagramController;


class AbstractDiagramView : public AbstractElementDocView {

public:
  AbstractDiagramView( QObject* objectPtr );

  DiagramController* diagramController() const;
  Diagram* diagram() const;

  /*! Returns MvcDiagram::id(). */
  inline static MvcModuleId_t classModuleId() { return MvcDiagram::id(); }
  /*! Returns classModuleId(). */
  virtual MvcModuleId_t moduleId() const { return classModuleId(); }


protected:
  virtual void dispatchEvent( VEvent* );

  virtual void changeControllerEvent( VChangeControllerEvent* );
  virtual void modelChangedEvent( VModelChangedEvent* );
  virtual void resetEvent( VEvent* );

  /*!
   * Conveniance event handler.
   *
   * \em Warning: It will be called in \em addition to changeControllerEvent().
   * It's useful when mixing multiple views together.
   *
   * This implementation does nothing.
   */
  virtual void changeDiagramControllerEvent( VChangeControllerEvent* ) {}

  /*!
   * Conveniance event handler.
   *
   * \em Warning: It will be called in \em addition to modelChangedEvent().
   * It's useful when mixing multiple views together.
   *
   * This implementation does nothing.
   */
  virtual void diagramModelChangedEvent( VModelChangedEvent* ) {}

  /*!
   * Conveniance event handler.
   *
   * \em Warning: It will be called in \em addition to resetEvent().
   * It's useful when mixing multiple views together.
   *
   * This implementation does nothing.
   */
  virtual void diagramResetEvent( VEvent* ) {}

  // The following implementations do nothing, derivative classes are left to
  // add functionality.
  virtual void controlPointInsertedEvent( VControlPointInsertedEvent* ) {}
  virtual void controlPointRemovedEvent( VControlPointRemovedEvent* ) {}
  virtual void controlPointMovedEvent( VControlPointMovedEvent* ) {}
  virtual void elementSelectionChangedEvent( VElementSelectionChangedEvent* ) {}

  void postDiagramEvent( CEvent* event );


private:
  // Temporary caches:
  QPointer<DiagramController> c_diagramController;
  QPointer<Diagram>           c_diagram;
};


#endif //  ! ABSTRACTDIAGRAMVIEW_H
