TEMPLATE = lib
LANGUAGE = C++

include( ../../config.pri ) ### Warning! we must set TEMPLATE and TARGET before we do this

CONFIG	+= qt warn_on  ### Warning! release/debug is set by config.pri
QT      += sql xml
QT      -= gui  # remove the GUI component (included by default), as we don`t use it

unix {
  UI_DIR = .ui
  MOC_DIR = .moc
  OBJECTS_DIR = .obj
}


# LIBRARY HEADER FILES
DEPENDPATH += ../include
INCLUDEPATH += ../include


# LIBRARY: Gesture
PRE_TARGETDEPS += ../Gesture/libGesture.dylib
LIBS += ../Gesture/libGesture.dylib
include( ../include/Gesture/paths.pri )

# LIBRARY: MvcCore
PRE_TARGETDEPS += ../MvcCore/libMvcCore.dylib
LIBS += ../MvcCore/libMvcCore.dylib
include( ../include/MvcCore/paths.pri )


DEPENDPATH  += . \
               .. \
               controllers \
               models \
               views
INCLUDEPATH += . \
               .. \
               controllers \
               models \
               views

HEADERS += ../sharedmacros.h \
           dclassrecord.h \
           dcollectionrecord.h \
           dexperimentrecord.h \
           dexperimentresultrecord.h \
           dgesturerecord.h \
           dtrainedrecogrecord.h \
           mvcdigestdb.h \
           digestdbcontainers.h \
           controllers/digestdbcontroller.h \
           controllers/digestdbcontrollerevents.h \
           models/digestdbmodel.h \
           models/digestdbmodelevents.h \
           views/abstractdigestdbview.h \
           views/digestdbviewevents.h

SOURCES += controllers/digestdbcontroller.cpp \
           models/digestdbmodel.cpp \
           views/abstractdigestdbview.cpp
