/*  -*- c++ -*-  (for Emacs)
 *
 *  digestdbcontroller.h
 *  Digest
 * 
 *  Created by Aidan Lane on Fri Aug 12 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIGESTDBCONTROLLER_H
#define DIGESTDBCONTROLLER_H


#include "MvcCore/abstractcontroller.h"

#include <QPointer>

#include "digestdbcontrollerevents.h"

class DigestDbModel;


/*!
 * \brief The DigestDbController class is responsible for controlling the
 *        communication between a DigestDbModel model its views.
 *
 * Note that the model's pointer is stored internally as a "guarded pointer".
 * Hence, if the model is deleted, our reference to it will be automatically
 * set back to 0.
 *
 * Warning! We always assert that the model is non-null. Hence, you can't
 * have an instance of a DigestDbController without a DigestDbModel.
 * This is fine in our case and means that we don't need to constantly check
 * if the diagram is null in the release / deployment version (when assertions
 * are stripped).
 */
class DigestDbController : public QObject, public AbstractController {

  Q_OBJECT

 public:
  DigestDbController( QObject* parent = 0 );
  DigestDbController( DigestDbModel* model, QObject* parent = 0 );

  DigestDbModel* digestDbModel() const;

  /*! Returns MvcDigestDb::id(). */
  inline static MvcModuleId_t classModuleId() { return MvcDigestDb::id(); }
  /*! Returns classModuleId(). */
  virtual MvcModuleId_t moduleId() const { return classModuleId(); }


 protected:
  inline virtual void customEvent( QEvent* e ) {
    CEvent* ce = dynamic_cast<CEvent*>(e);
    if ( ce != 0 ) dispatchEvent(ce);
  }
  virtual void dispatchEvent( CEvent* );

  virtual void changeModelEvent( CChangeModelEvent* );

  virtual void classAddEvent( CClassAddEvent* );
  virtual void classUpdateEvent( CClassUpdateEvent* );
  virtual void classesRemoveEvent( CClassesRemoveEvent* );

  virtual void collectionAddEvent( CCollectionAddEvent* );
  virtual void collectionUpdateEvent( CCollectionUpdateEvent* );
  virtual void collectionsRemoveEvent( CCollectionsRemoveEvent* );

  virtual void experimentAddEvent( CExperimentAddEvent* );
  virtual void experimentUpdateEvent( CExperimentUpdateEvent* );
  virtual void experimentsRemoveEvent( CExperimentsRemoveEvent* );

  virtual void gestureAddEvent( CGestureAddEvent* );
  virtual void gestureUpdateEvent( CGestureUpdateEvent* );
  virtual void gesturesChangeClassesEvent( CGesturesChangeClassesEvent* );
  virtual void gesturesChangeCollectionsEvent( CGesturesChangeCollectionsEvent* );
  virtual void gesturesRemoveEvent( CGesturesRemoveEvent* );

  virtual void trainedRecogAddEvent( CTrainedRecogAddEvent* );
  virtual void trainedRecogUpdateEvent( CTrainedRecogUpdateEvent* );
  virtual void trainedRecogsRemoveEvent( CTrainedRecogsRemoveEvent* );


 private:
  // Temporary caches:
  QPointer<DigestDbModel> c_digestDbModel;
};


#endif // ! DIGESTDBCONTROLLER_H
