/*  -*- c++ -*-  (for Emacs)
 *
 *  digestdbcontrollerevents.h
 *  Digest
 * 
 *  Created by Aidan Lane on Fri Aug 12 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIGESTDBCONTROLLEREVENTS_H
#define DIGESTDBCONTROLLEREVENTS_H


#include "MvcCore/controllerevents.h"
#include "MvcCore/genericcontainers.h"

#include "mvcdigestdb.h"
#include "digestdbcontainers.h"


class CDigestDbEvent : public CEvent {

public:
  enum Type {    
    ClassAdd            = CEvent::User,
    ClassUpdate,
    ClassesRemove,
    CollectionAdd,
    CollectionUpdate,
    CollectionsRemove,
    ExperimentAdd,
    ExperimentUpdate,
    ExperimentsRemove,
    GestureAdd,
    GestureUpdate,
    GesturesChangeClasses,
    GesturesChangeCollections,
    GesturesRemove,
    TrainedRecogAdd,
    TrainedRecogUpdate,
    TrainedRecogsRemove,
    User                = CEvent::User + 1000
  };

  CDigestDbEvent( Type type,
		  QObject* sender = 0, Flags flags = NoFlags )
    : CEvent((CEvent::Type)type, sender, flags) {}

  /*! Returns MvcDigestDb::id(). */
  inline static MvcModuleId_t classModuleId() { return MvcDigestDb::id(); }
  /*! Returns classModuleId(). */
  virtual MvcModuleId_t moduleId() const { return classModuleId(); }
};


class CClassAddEvent : public CDigestDbEvent, public DClassRecordContainer {
public:
  CClassAddEvent( const DClassRecord& record,
		  QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(ClassAdd, sender, flags),
      DClassRecordContainer(record) {}
};

class CClassUpdateEvent : public CDigestDbEvent, public DClassRecordContainer {
public:
  CClassUpdateEvent( const DClassRecord& record,
		     QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(ClassUpdate, sender, flags),
      DClassRecordContainer(record) {}
};

class CClassesRemoveEvent : public CDigestDbEvent, public IdSetContainer {
public:
  CClassesRemoveEvent( const IdSet& idSet,
		       QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(ClassesRemove, sender, flags),
      IdSetContainer(idSet) {}
  CClassesRemoveEvent( int id, QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(ClassesRemove, sender, flags),
      IdSetContainer(id) {}
};


class CCollectionAddEvent : public CDigestDbEvent,
			    public DCollectionRecordContainer {
public:
  CCollectionAddEvent( const DCollectionRecord& record,
		       QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(CollectionAdd, sender, flags),
      DCollectionRecordContainer(record) {}
};

class CCollectionUpdateEvent : public CDigestDbEvent,
			       public DCollectionRecordContainer {
public:
  CCollectionUpdateEvent( const DCollectionRecord& record,
			  QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(CollectionUpdate, sender, flags),
      DCollectionRecordContainer(record) {}
};

class CCollectionsRemoveEvent : public CDigestDbEvent, public IdSetContainer {
public:
  CCollectionsRemoveEvent( const IdSet& idSet,
			   QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(CollectionsRemove, sender, flags),
      IdSetContainer(idSet) {}
  CCollectionsRemoveEvent( int id, QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(CollectionsRemove, sender, flags),
      IdSetContainer(id) {}
};


class CExperimentAddEvent : public CDigestDbEvent,
			    public DExperimentRecordContainer {
public:
  CExperimentAddEvent( const DExperimentRecord& record,
		       QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(ExperimentAdd, sender, flags),
      DExperimentRecordContainer(record) {}
};

class CExperimentUpdateEvent : public CDigestDbEvent,
			       public DExperimentRecordContainer {
public:
  CExperimentUpdateEvent( const DExperimentRecord& record,
			  QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(ExperimentUpdate, sender, flags),
      DExperimentRecordContainer(record) {}
};

class CExperimentsRemoveEvent : public CDigestDbEvent, public IdSetContainer {
public:
  CExperimentsRemoveEvent( const IdSet& idSet,
			   QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(ExperimentsRemove, sender, flags),
      IdSetContainer(idSet) {}
  CExperimentsRemoveEvent( int id, QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(ExperimentsRemove, sender, flags),
      IdSetContainer(id) {}
};


class CGestureAddEvent : public CDigestDbEvent,
			 public DGestureRecordContainer {
public:
  CGestureAddEvent( const DGestureRecord& record,
		    QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(GestureAdd, sender, flags),
      DGestureRecordContainer(record) {}
};

class CGestureUpdateEvent : public CDigestDbEvent,
			    public DGestureRecordContainer {
public:
  CGestureUpdateEvent( const DGestureRecord& record,
		       QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(GestureUpdate, sender, flags),
      DGestureRecordContainer(record) {}
};

/*! This event exists for both convenience and efficiency purposes. */
class CGesturesChangeClassesEvent : public CDigestDbEvent,
				    public IdSetContainer,
				    public AddSetContainer<int>,
				    public RemoveSetContainer<int> {
public:
  CGesturesChangeClassesEvent( const IdSet& idSet,
			       const IdSet& addSet,
			       const IdSet& removeSet,
			       QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(GesturesChangeClasses, sender, flags),
      IdSetContainer(idSet),
      AddSetContainer<int>(addSet),
      RemoveSetContainer<int>(removeSet) {}
};

/*! This event exists for both convenience and efficiency purposes. */
class CGesturesChangeCollectionsEvent : public CDigestDbEvent,
					public IdSetContainer,
					public AddSetContainer<int>,
					public RemoveSetContainer<int> {
public:
  CGesturesChangeCollectionsEvent( const IdSet& idSet,
				   const IdSet& addSet,
				   const IdSet& removeSet,
				   QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(GesturesChangeCollections, sender, flags),
      IdSetContainer(idSet),
      AddSetContainer<int>(addSet),
      RemoveSetContainer<int>(removeSet) {}
};

class CGesturesRemoveEvent : public CDigestDbEvent, public IdSetContainer {
public:
  CGesturesRemoveEvent( const IdSet& idSet,
			QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(GesturesRemove, sender, flags),
      IdSetContainer(idSet) {}
  CGesturesRemoveEvent( int id, QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(GesturesRemove, sender, flags),
      IdSetContainer(id) {}
};


class CTrainedRecogAddEvent : public CDigestDbEvent,
			      public DTrainedRecogRecordContainer {
public:
  CTrainedRecogAddEvent( const DTrainedRecogRecord& record,
			 QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(TrainedRecogAdd, sender, flags),
      DTrainedRecogRecordContainer(record) {}
};

class CTrainedRecogUpdateEvent : public CDigestDbEvent,
				 public DTrainedRecogRecordContainer {
public:
  CTrainedRecogUpdateEvent( const DTrainedRecogRecord& record,
			    QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(TrainedRecogUpdate, sender, flags),
      DTrainedRecogRecordContainer(record) {}
};

class CTrainedRecogsRemoveEvent : public CDigestDbEvent, public IdSetContainer {
public:
  CTrainedRecogsRemoveEvent( const IdSet& idSet,
			    QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(TrainedRecogsRemove, sender, flags),
      IdSetContainer(idSet) {}
  CTrainedRecogsRemoveEvent( int id, QObject* sender = 0, Flags flags = NoFlags )
    : CDigestDbEvent(TrainedRecogsRemove, sender, flags),
      IdSetContainer(id) {}
};


#endif //  ! DIGESTDBCONTROLLEREVENTS_H
