/*  -*- c++ -*-  (for Emacs)
 *
 *  dexperimentrecord.h
 *  Digest
 * 
 *  Created by Aidan Lane on Thu Nov 3 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DEXPERIMENTRECORD_H
#define DEXPERIMENTRECORD_H


#include <QDate>
#include <QString>


/*!
 * \b Notes:
 *
 * 1. Even though the Experiment Assistant may be used to perform experiments
 *    with multiple trained recognisers at once, each recogniser tested will
 *    have it's own experiment ID and thus also a row of the Experiment table
 *    assigned to it (for that experiment run).
 *
 * 2. The database can be used to store the results of external experiments,
 *    thus the reason for having the "external" boolean field.
 *
 * 3. The actual results of each experiment are stored in the ExperimentResult
 *    table.
 *
 * \b Note: This is a class, not a struct, so that it can be used as a template
 *          parameter.
 */
class DExperimentRecord {
public:
  DExperimentRecord( int id = -1, const QString& label = QString() )
    : id(id),
      label(label),
      external(false),
      trainedRecogniserId(-1) {}
  int        id;
  QString    label;
  bool       external;
  QDate      date;
  QString    notes;
  int        trainedRecogniserId;
  QString    cachedCorrectText;
  QString    cachedIncorrectText;
};


#endif  // ! DEXPERIMENTRECORD_H
