/*  -*- c++ -*-  (for Emacs)
 *
 *  dexperimentresultrecord.h
 *  Digest
 * 
 *  Created by Aidan Lane on Sun Mar 26 2006.
 *  Copyright (c) 2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DEXPERIMENTRESULTRECORD_H
#define DEXPERIMENTRESULTRECORD_H


#include <QHash>


/*
 * Note: For each Class index, the probability value should range between
 *       0.0 and 1.0 (inclusive).
 *
 *       We use DOUBLE (vs. float), as we use ClassProbabilityT in our calcs,
 *       as to keep the precision consistent, which in turn to minimises error.
 */
typedef double                                        ClassProbabilityT;
typedef QHash<int, ClassProbabilityT>                 ClassProbabilities;
typedef QHashIterator<int, ClassProbabilityT>         ClassProbabilitiesIterator;
typedef QMutableHashIterator<int, ClassProbabilityT>  MutableClassProbabilitiesIterator;


#if 0 // update this to reflect the new system
/*!
 * \b Notes:
 *
 * 1. The class ID of the gesture that is tested is also recorded, even though
 *    it's redundant. We do so because the gesture could be removed at any time
 *    - but we wan't the results to still be of use. If a given gesture belongs
 *    to more than one class, then the number of result rows will be multiplied
 *    by that number of classes, as to have each combination listed.
 *
 * 2. The results could have been kept more compact if each of the class->prob
 *    entries were linked together in one field, BUT the format used aids
 *    querying of the SQL database.
 *
 * 3. There may be multiple rows with the same experimentId, testGestureId and
 *    testClassId. This will occur if for example the recogniser in experiment
 *    E returns with a prob. of 0.9 that gesture G of class C belongs to class
 *    X and 0.1 that be belongs to class Y.
 *
 * 4. As noted for the experiment table: Even though the Experiment Assistant
 *    may be used to perform experiments with multiple trained recognisers at
 *    once, each recogniser tested will have it's own experiment ID and thus
 *    also a row of the Experiment table assigned to it (for that experiment
 *    run).
 *
 * \b Note: This is a class, not a struct, so that it can be used as a template
 *          parameter.
 */
class DExperimentResultRecord {
public:
  DExperimentResultRecord( int experimentId   = -1,
			   int testGestureId  = -1,
			   int testClassId    = -1,
			   int resultClassId  = -1,
			   ClassProbabilityT resultClassProb = -1.0 )
    : experimentId(experimentId),
      testGestureId(testGestureId),
      testClassId(testClassId),
      resultClassId(resultClassId),
      resultClassProb(resultClassProb) {}
  int                experimentId;
  int                testGestureId;
  int                testClassId;
  int                resultClassId;
  ClassProbabilityT  resultClassProb;
};
#endif


#endif  // ! DEXPERIMENTRESULTRECORD_H
