/*  -*- c++ -*-  (for Emacs)
 *
 *  dgesturerecord.h
 *  Digest
 * 
 *  Created by Aidan Lane on Mon Jun 27 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DGESTURERECORD_H
#define DGESTURERECORD_H


#include <QDate>
#include <QSet>
#include <QString>

#include "Gesture/strokelist.h"


/*!
 * Note that although this is called a "record", its members are high-level
 * and more friendly than what's stored in the SQL database.
 * It's called a "record" mainly for consistency.
 *
 *
 * \b Note: This is a class, not a struct, so that it can be used as a template
 *          parameter.
 */
class DGestureRecord {
public:
  // The following constructors at least initialise the IDs to -1, which means
  // that they don't currently point to valid data (0 is a valid ID in SQL).
  DGestureRecord( int id = -1, const QString& label = QString() )
    : id(id),
      label(label) {}
  DGestureRecord( const StrokeList& strokes, int id = -1,
		  const QString& label = QString() )
    : id(id),
      label(label),
      strokes(strokes) {}

  int        id;
  QString    label;
  QDate      date;
  QString    notes;
  StrokeList strokes;     /*! An \b ordered list of strokes. */
  QSet<int>  classes;     /*! QSet, not QList, as it's naturally unordered and
			    shouldn't contain duplicates. */
  QSet<int>  collections; /*! QSet, not QList, as it's naturally unordered and
			    shouldn't contain duplicates. */
};


#endif  // ! DGESTURERECORD_H
