/*  -*- c++ -*-  (for Emacs)
 *
 *  digestdbcontainers.h
 *  Digest
 * 
 *  Created by Aidan Lane on Fri Aug 12 2005.
 *  Copyright (c) 2005-2006 Optimisation and Constraint Solving Group,
 *  Monash University. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef DIGESTDBCONTAINERS_H
#define DIGESTDBCONTAINERS_H


#include "dclassrecord.h"
#include "dcollectionrecord.h"
#include "dexperimentrecord.h"
#include "dgesturerecord.h"
#include "dtrainedrecogrecord.h"


template <class T>
class RecordContainer {
public:
  RecordContainer( const T& record )
    : m_record(record) {}
  const T& record() const { return m_record; }
private:
  const T m_record;
};


typedef RecordContainer<DClassRecord>         DClassRecordContainer;
typedef RecordContainer<DCollectionRecord>    DCollectionRecordContainer;
typedef RecordContainer<DExperimentRecord>    DExperimentRecordContainer;
typedef RecordContainer<DGestureRecord>       DGestureRecordContainer;
typedef RecordContainer<DTrainedRecogRecord>  DTrainedRecogRecordContainer;


#endif //  ! DIGESTDBCONTAINERS_H
